# Requirements: www.IT-Visions.de Commandlet Extension Library
# http://www.powershell-doktor.de

# Parameters
$SQL = "Select * from users order by UserSurname"
$Conn = "Provider=Microsoft.Jet.OLEDB.4.0;Data Source=H:\demo\PowerShell\Datenbanken\users.mdb;"
$Provider = "ACCESS"

"----------Test database connections:"
test-dbconnection -connection $Conn   -sql $SQL -provider $Provider 

"---------- Execute Commands:"

$SQL1 = "Select count(*) from users"
$SQL2 = "insert into users ( UserFirstName, UserSurname) values ('Hans', 'Meier')"
$SQL3 = "delete from users where UserSurname='Meier'"

invoke-ScalarDbCommand -connection $Conn   -sql $SQL1 -provider $Provider 
invoke-DbCommand -connection $Conn   -sql $SQL2 -provider $Provider 
invoke-ScalarDbCommand -connection $Conn   -sql $SQL1 -provider $Provider 
invoke-DbCommand -connection $Conn   -sql $SQL3 -provider $Provider 
invoke-ScalarDbCommand -connection $Conn   -sql $SQL1 -provider $Provider 

"---------- Get Data "

$table = Get-DbTable -connection $Conn   -sql $SQL -provider  $Provider  
$table | ft

"---------- Select Row "
$row = $table | where  { $_.usersurname -eq "Pfister" }
$Row

"---------- Change Row "
$row.UsercreateDate = [DateTime] "11/11/2005"
$Row

"---------- Update Data "
$table | Set-DbTable -connection $Conn -sql $sql -provider  $Provider  -verbose

"---------- Get Row"
$SQL = "Select * from users where usersurname = 'Pfister'"
$row = Get-DbRow $Conn $SQL $Provider
$row
